% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.R
\name{dbplot_line}
\alias{dbplot_line}
\title{Bar plot}
\usage{
dbplot_line(data, x, ..., y = n())
}
\arguments{
\item{data}{A table (tbl)}

\item{x}{A discrete variable}

\item{...}{A set of named or unamed aggregations}

\item{y}{The aggregation formula. Defaults to count (n)}
}
\description{
Uses very generic dplyr code to aggregate data and then `ggplot2`
to create a line plot.  Because of this approach,
the calculations automatically run inside the database if `data` has
a database or sparklyr connection. The `class()` of such tables
in R are: tbl_sql, tbl_dbi, tbl_spark

If multiple named aggregations are passed, `dbplot` will only use one
SQL query to perform all of the operations.  The purpose is to increase
efficiency, and only make one "trip" to the database in order to
obtains multiple, related, plots.
}
\examples{

library(ggplot2)
library(dplyr)

# Returns a plot of the row count per cyl
mtcars \%>\%
  dbplot_line(cyl)

# Returns a plot of the average mpg per cyl
mtcars \%>\%
  dbplot_line(cyl, mean(mpg))

# Returns the average and sum of mpg per am
mtcars \%>\%
  dbplot_line(am, avg_mpg = mean(mpg), sum_mpg = sum(mpg))
}
\seealso{
\code{\link{dbplot_bar}},
\code{\link{dbplot_histogram}},  \code{\link{dbplot_raster}}
}
