% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-head.R
\name{head.tbl_lazy}
\alias{head.tbl_lazy}
\title{Subset the first rows}
\usage{
\method{head}{tbl_lazy}(x, n = 6L, ...)
}
\arguments{
\item{x}{A lazy data frame backed by a database query.}

\item{n}{Number of rows to return}

\item{...}{Not used.}
}
\value{
Another \code{tbl_lazy}. Use \code{\link[=show_query]{show_query()}} to see the generated
query, and use \code{\link[=collect.tbl_sql]{collect()}} to execute the query
and return data to R.
}
\description{
This is a method for the \code{\link[=head]{head()}} generic. It is usually translated to the
\code{LIMIT} clause of the SQL query. Because \code{LIMIT} is not an official part of
the SQL specification, some database use other clauses like \code{TOP} or
\verb{FETCH ROWS}.

Note that databases don't really have a sense of row order, so what "first"
means is subject to interpretation. Most databases will respect ordering
performed with \code{arrange()}, but it's not guaranteed. \code{tail()} is not
supported at all because the situation is even murkier for the "last" rows.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(x = 1:100)
db \%>\% head() \%>\% show_query()

# Pretend we have data in a SQL server database
db2 <- lazy_frame(x = 1:100, con = simulate_mssql())
db2 \%>\% head() \%>\% show_query()
}
