% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-ids-duplicate.R
\name{check_indiv_ids_dup}
\alias{check_indiv_ids_dup}
\alias{check_specimen_ids_dup}
\title{Check uniqueness of individual and specimen IDs}
\usage{
check_indiv_ids_dup(
  data,
  empty_values = c(NA, ""),
  success_msg = "Individual IDs are unique",
  fail_msg = "Duplicate individual IDs found"
)

check_specimen_ids_dup(
  data,
  empty_values = c(NA, ""),
  success_msg = "Specimen IDs are unique",
  fail_msg = "Duplicate specimen IDs found"
)
}
\arguments{
\item{data}{Individual metadata file}

\item{empty_values}{Values that are considered empty. Defaults to \code{NA} and
\code{""}.}

\item{success_msg}{Message indicating the check succeeded.}

\item{fail_msg}{Message indicating the check failed.}
}
\value{
A condition object indicating whether the individual IDs in the
individual metadata file are unique.
}
\description{
Check uniqueness of individual and specimen IDs
}
\examples{
dat1 <- data.frame(individualID = c("x", "y", "z", "z"))
check_indiv_ids_dup(dat1)

dat2 <- data.frame(
  individualID = c("x", "y", "z"),
  specimenID = c("a", "a", "b")
)
check_specimen_ids_dup(dat2)
}
