% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-annotation-values.R
\name{check_values}
\alias{check_values}
\title{Check a set of keys and their values}
\usage{
check_values(
  x,
  annotations,
  whitelist_keys = NULL,
  whitelist_values = NULL,
  success_msg = "All annotation values are valid",
  fail_msg = "Some annotation values are invalid",
  return_valid = FALSE,
  annots_link = "https://shinypro.synapse.org/users/nsanati/annotationUI/",
  syn
)
}
\arguments{
\item{x}{A data frame of annotation data}

\item{annotations}{A data frame of annotations to check against}

\item{whitelist_keys}{A character vector of annotation keys to whitelist. If
provided, all values for the given keys will be treated as valid.}

\item{whitelist_values}{A named list of keys (as the names) and values (as
vectors) to whitelist}

\item{success_msg}{Message indicating the check succeeded.}

\item{fail_msg}{Message indicating the check failed.}

\item{return_valid}{Should the function return valid values? Defaults to
\code{FALSE} (i.e. the function will return invalid values).}

\item{annots_link}{Link to a definition of the annotations being used in the
project}

\item{syn}{Synapse client object}
}
\value{
If \code{return_valid = FALSE}: a condition object indicating whether all
annotation values are valid. Invalid annotation values are included as data
within the object: a named list where each element corresponds to a key
that contains invalid values, and the contents of each element is a vector
of invalid values. If \code{return_valid = TRUE}: a named list of the valid
annotation keys and values.
}
\description{
Check a set of keys and their values
}
\examples{
annots <- data.frame(
  key = c("fileFormat", "fileFormat"),
  value = c("txt", "csv"),
  columnType = c("STRING", "STRING"),
  stringsAsFactors = FALSE
)
dat <- data.frame(
  fileFormat = c("wrong", "txt", "csv", "wrong again"),
  stringsAsFactors = FALSE
)
check_values(dat, annots)
}
