% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify,ANY,modifier-method}
\alias{modify,ANY,modifier-method}
\title{Apply corrections/derivations to a db table}
\usage{
\S4method{modify}{ANY,modifier}(
  dat,
  x,
  copy = NULL,
  transaction = !isTRUE(copy),
  ignore_nw = FALSE,
  ...
)
}
\arguments{
\item{dat}{\code{\link[=tbl_sql]{tbl_sql()}} object, table in a SQL database}

\item{x}{\code{dcmodify::modifier()} object.}

\item{copy}{if \code{TRUE} (default), modify copy of table}

\item{transaction}{if \code{TRUE} use one transaction for all modifications.}

\item{ignore_nw}{if \code{TRUE} non-working rules are ignored}

\item{...}{unused}
}
\value{
\code{\link[=tbl_sql]{tbl_sql()}} object, referencing the modified table object.
}
\description{
Change records in a database table using modification rules specified
in a \code{\link[=modifier]{modifier()}} object. This is the main function of package \code{dcmodifydb}.
For more information see the vignettes.
}
\details{
The modification rules are translated into SQL update statements
and executed on the table.

Note that
\itemize{
\item by default the updates are executed on a copy of the table.
\item the default for \code{transaction} is \code{FALSE} when \code{copy=TRUE} and
\code{TRUE} when \code{copy=FALSE}
\item when \code{transaction = TRUE} and a modification fails,
all modifications are rolled back.
}
}
\examples{
library(DBI)
library(dcmodify)
library(dcmodifydb)

# silly modification rules
m <- modifier( if (cyl == 6)  gear <- 10
             , gear[cyl == 4] <- 0  # this R syntax works too :-)
             , if (gear == 3) cyl <- 2
             )

# setting up a table in the database
con <- dbConnect(RSQLite::SQLite())
dbWriteTable(con, "mtcars", mtcars[,c("cyl", "gear")])
tbl_mtcars <- dplyr::tbl(con, "mtcars")

# "Houston, we have a table"
head(tbl_mtcars)

# lets modify on a temporary copy of the table..
# this copy is only visible to the current connection
tbl_m <- modify(tbl_mtcars, m, copy=TRUE)


# and gear has changed...
head(tbl_m)

# If one certain about the changes, then you can overwrite the table with the changes
tbl_m <- modify(tbl_mtcars, m, copy=FALSE)

dbDisconnect(con)
}
