% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-wildtype_mutant_pnpp.R
\name{wells_wildtype}
\alias{wells_wildtype}
\title{Get wildtype wells}
\usage{
wells_wildtype(plate)
}
\arguments{
\item{plate}{A ddPCR plate.}
}
\value{
Character vector with well IDs of wildtype wells
}
\description{
After a ddPCR plate of type \code{wildtype_mutant_pnpp} has been analyzed,
get the wells that were deemed as wildtype.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$fam_positive_pnpp) \%>\% analyze
wells_wildtype(plate)
}
}
\seealso{
\code{\link[ddpcr]{wildtype_mutant_pnpp}}\cr
\code{\link[ddpcr]{wells_mutant}}
}
