% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.perf_mddsPLS.R
\name{plot.perf_mddsPLS}
\alias{plot.perf_mddsPLS}
\title{Function to plot cross-validation performance results.}
\usage{
\method{plot}{perf_mddsPLS}(x, plot_mean = FALSE, legend_names = NULL,
  pos_legend = "bottomleft", ...)
}
\arguments{
\item{x}{The perf_mddsPLS object.}

\item{plot_mean}{logical. Whether or not to plot the mean curve.}

\item{legend_names}{vector of characters. Each element is the name of one of the q response variables.}

\item{pos_legend}{character. One of "bottomleft", "topright",....}

\item{...}{Other plotting parameters to affect the plot.}
}
\value{
The plot visualisation
}
\description{
That function must be applied to a perf_mddsPLS object. Extra parameters are
 avalaible to control the plot quality.
}
\examples{
library(doParallel)
# Classification example :
data("penicilliumYES")
X <- penicilliumYES$X
X <- scale(X[,which(apply(X,2,sd)>0)])
Y <- as.factor(unlist(lapply(c("Melanoconidiu","Polonicum","Venetum"),
function(tt){rep(tt,12)})))
#res_cv_class <- perf_mddsPLS(X,Y,lambda_min=0.85,n_lambda=2,R = 2,
#mode = "clas",NCORES = 1,fold_fixed = rep(1:12,3))
#plot(res_cv_class)

# Regression example :
data("liver.toxicity")
X <- scale(liver.toxicity$gene)
Y <- scale(liver.toxicity$clinic)
#res_cv_reg <- perf_mddsPLS(Xs = X,Y = Y,lambda_min=0.8,n_lambda=2,R = 1,
# mode = "reg")
#plot(res_cv_reg)
}
