%                               -*- Mode: Rd -*- 
% conditional.Rd --- 
% Author          : Claus Dethlefsen
% Created On      : Sat May 25 23:01:34 2002
% Last Modified By: Claus Dethlefsen
% Last Modified On: Thu Jul 24 15:33:54 2003
% Update Count    : 20
% Status          : Unknown, Use with caution!
% 

\name{conditional}
\alias{conditional.cont}
\alias{conditional.disc}
\alias{conditional}
\alias{cond.node}
\alias{cond}

%- Also NEED an `\alias' for EACH other topic documented here.

\title{Calculate conditional distribution}

\description{From master distribution the conditional distribution of a
  node given the parents is calculated.
}

\usage{
conditional.cont(A,mu,nu,rho,phi) 
conditional(A,master,nw) 
conditional.disc(A,master) 
cond.node(node,nw,nw.prior=jointprior(nw)) 
}

%- maybe also `usage' for other objects documented here.
\arguments{
  \item{nw}{an object of class \code{\link{network}}.}
  \item{node}{integer, giving the index of the current node.}
  \item{nw.prior}{a list describing parameter priors, generated by \code{\link{jointprior}}.}
  \item{A}{integer, giving the index of the current node.}
  \item{master}{a list describing the local master, generated by \code{\link{localmaster}}.}
  \item{mu}{numeric vector. Mu is a parameter in the local master.}
  \item{nu}{numeric. Nu is a parameter in the local master.}
  \item{rho}{numeric. Rho is a parameter in the local master.}
  \item{phi}{numeric matrix. Phi is a parameter in the local master.}
  
}

\seealso{\code{\link{learn}},
  \code{\link{localmaster}}
  }

\details{Used in \code{\link{learn}}, which calls \code{cond.node}. The
  local master is calculated and sent to \code{conditional} which calls either
  \code{conditional.cont} or \code{conditional.disc} depending on the
  type of the node. In each case the \code{\link{localmaster}} is used
  for calculating the conditional distribution of the current node given
  the remaining nodes in the local master.
}

\value{The node is updated with \code{condprior} property, consisting of
  a list with components
  \item{tau}{a numeric matrix, giving the unscaled precision matrix of
    regression parameters.}
  \item{mu}{a numeric vector, giving the mean of the regression parameters.}
  \item{phi}{a numeric, giving a parameter in the distribution of the
    scale parameter.}
  \item{rho}{a numeric, giving a parameter in the distribution of the
    scale parameter.}
  \item{alpha}{a numeric matrix with parameters for Dirichlet distribution.}
}

\references{
  Further information about \bold{deal} can be found at:\cr
  \url{http://www.math.auc.dk/novo/deal}.
}

\author{
  Susanne Gammelgaard Bttcher \email{alma@math.auc.dk}, \cr
  Claus Dethlefsen \email{dethlef@math.auc.dk}.
}

%\note{ ~~further notes~~ }

% ~Make other sections like WARNING with \section{WARNING }{....} ~


\keyword{iplot}
