% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{sq_dist}
\alias{sq_dist}
\title{Calculates squared pairwise distances}
\usage{
sq_dist(X1, X2 = NULL)
}
\arguments{
\item{X1}{matrix of input locations}

\item{X2}{matrix of second input locations (if \code{NULL}, distance is calculated
between \code{X1} and itself)}
}
\value{
symmetric matrix of squared euclidean distances
}
\description{
Calculates squared pairwise euclidean distances using C.
}
\details{
C code derived from the "laGP" package (Robert B Gramacy and Furong Sun).
}
\examples{
x <- seq(0, 1, length = 10)
d2 <- sq_dist(x)

}
\references{
Gramacy, RB and F Sun. (2016). laGP: Large-Scale Spatial Modeling via Local 
    Approximate Gaussian Processes in R. \emph{Journal of Statistical Software 
    72} (1), 1-46. doi:10.18637/jss.v072.i01
}
