% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.gp}
\alias{predict.dgp2}
\alias{predict.dgp3}
\title{Predict posterior mean and variance/covariance}
\usage{
\method{predict}{gp}(object, x_new, lite = TRUE, EI = FALSE, cores = 1, ...)

\method{predict}{dgp2}(
  object,
  x_new,
  lite = TRUE,
  store_latent = FALSE,
  mean_map = TRUE,
  EI = FALSE,
  cores = 1,
  ...
)

\method{predict}{dgp3}(
  object,
  x_new,
  lite = TRUE,
  store_latent = FALSE,
  mean_map = TRUE,
  EI = FALSE,
  cores = 1,
  ...
)
}
\arguments{
\item{object}{object from \code{fit_one_layer}, \code{fit_two_layer}, or 
\code{fit_three_layer} with burn-in already removed}

\item{x_new}{matrix of predictive input locations}

\item{lite}{logical indicating whether to calculate only point-wise 
variances (\code{lite = TRUE}) or full covariance 
(\code{lite = FALSE})}

\item{EI}{logical indicating whether to calculate expected improvement 
(for minimizing the response)}

\item{cores}{number of cores to utilize in parallel, by default no 
parallelization is used}

\item{...}{N/A}

\item{store_latent}{logical indicating whether to store and return mapped 
values of latent layers (\code{dgp2} or \code{dgp3} only)}

\item{mean_map}{logical indicating whether to map hidden layers using 
conditional mean (\code{mean_map = TRUE}) or using a random sample
from the full MVN distribution (\code{dgp2} or \code{dgp3} only)}
}
\value{
object of the same class with the following additional elements:
\itemize{
  \item \code{x_new}: copy of predictive input locations
  \item \code{tau2}: vector of tau2 estimates (governing the magnitude of 
        the covariance)
  \item \code{mean}: predicted posterior mean, indices correspond to 
        \code{x_new} location
  \item \code{s2}: predicted point-wise variances, indices correspond to 
        \code{x_new} location (only returned when \code{lite = TRUE})
  \item \code{s2_smooth}: predicted point-wise variances with \code{g} 
        removed, indices correspond to \code{x_new} location (only returned 
        when \code{lite = TRUE})
  \item \code{Sigma}: predicted posterior covariance, indices correspond to 
        \code{x_new} location (only returned when \code{lite = FALSE})
  \item \code{Sigma_smooth}: predicted posterior covariance with \code{g} 
        removed from the diagonal (only returned when \code{lite = FALSE})
  \item \code{EI}: vector of expected improvement values, indices correspond 
        to \code{x_new} location (only returned when \code{EI = TRUE})
  \item \code{w_new}: list of hidden layer mappings (only returned when 
        \code{store_latent = TRUE}), list index corresponds to iteration and 
        row index corresponds to \code{x_new} location (\code{dgp2} and 
        \code{dgp3} only)
  \item \code{z_new}: list of hidden layer mappings (only returned when 
        \code{store_latent = TRUE}), list index corresponds to iteration and 
        row index corresponds to \code{x_new} location (\code{dgp3} only) 
}
Computation time is added to the computation time of the existing object.
}
\description{
Acts on a \code{gp}, \code{dgp2}, or \code{dgp3} object.
    Calculates posterior mean and variance/covariance over specified input 
    locations.  Optionally calculates expected improvement (EI) over candidate
    inputs.  Optionally utilizes SNOW parallelization.
}
\details{
All iterations in the object are used for prediction, so samples 
    should be burned-in.  Thinning the samples using \code{trim} will speed 
    up computation.  Posterior moments are calculated using conditional 
    expectation and variance.  As a default, only point-wise variance is 
    calculated.  Full covariance may be calculated using \code{lite = FALSE}. 
    
    Expected improvement is calculated with the goal of minimizing the 
    response.  See Chapter 7 of Gramacy (2020) for details.
    
    SNOW parallelization reduces computation time but requires significantly 
    more memory storage.  Use \code{cores = 1} if memory is limited.
}
\examples{
# See "deepgp-package", "fit_one_layer", "fit_two_layer", or "fit_three_layer"
# for an example

}
\references{
Sauer, A, RB Gramacy, and D Higdon. 2020. "Active Learning for Deep Gaussian 
    Process Surrogates." \emph{Technometrics, to appear;} arXiv:2012.08015. 
    \cr\cr
Gramacy, RB. \emph{Surrogates: Gaussian Process Modeling, Design, and 
    Optimization for the Applied Sciences}. Chapman Hall, 2020.
}
