% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_dnn.R
\name{new_dnn}
\alias{new_dnn}
\title{Creats a new instance of darch class}
\usage{
new_dnn(layer_structure, layer_functions = NULL,
  output_layer_default = linearUnitDerivative,
  hidden_layer_default = rectified_linear_unit_function,
  weight_initiliazaiton = generateWeights)
}
\arguments{
\item{layer_structure}{a int vector that specifies the number and width of layers}

\item{layer_functions}{a list of activation functions used by each layer}

\item{output_layer_default}{the activation function for the output layer}

\item{hidden_layer_default}{the activation function for the hidden layers}

\item{weight_initiliazaiton}{function that initialize a layer's weight matrix}
}
\description{
This function creates a new instance of darch class
}
\examples{
# create a new deep neural network for classificaiton
dnn_regression <- new_dnn(
 c(2, 50, 50, 20, 1),
 # The layer structure of the deep neural network.
 # The first element is the number of input variables.
 # The last element is the number of output variables.
 hidden_layer_default = rectified_linear_unit_function,
 # for hidden layers, use rectified_linear_unit_function
 output_layer_default = sigmoidUnitDerivative
 # for classification, use sigmoidUnitDerivative function
)

# create a new deep neural network for classificaiton
dnn_regression <- new_dnn(
 c(2, 50, 50, 20, 1),
 # The layer structure of the deep neural network.
 # The first element is the number of input variables.
 # The last element is the number of output variables.
 hidden_layer_default = rectified_linear_unit_function,
 # for hidden layers, use rectified_linear_unit_function
 output_layer_default = linearUnitDerivative
 # for regression, use linearUnitDerivative function
)
}

