% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{print_weight}
\alias{print_weight}
\title{Prints out the weight of a deep neural network}
\usage{
print_weight(darch, num_of_layer, show_derivative = F, type = "heatmap")
}
\arguments{
\item{darch}{DArch instance}

\item{num_of_layer}{the number of the layer to print}

\item{show_derivative}{T to show the weight value. F to show the percentage
weight change in the finetuning stage. This helps spot the network saturation problem.}

\item{type}{type of the graph. It supports "heatmap", "surface", and "histogram"}
}
\description{
This function prints out the weight in a heat map, 3D surface, or histogram
}
\examples{
# Example of Regression

input <- matrix(runif(1000), 500, 2)
input_valid <- matrix(runif(100), 50, 2)
target <- rowSums(input + input^2)
target_valid <- rowSums(input_valid + input_valid^2)
# create a new deep neural network for classificaiton
dnn_regression <- new_dnn(
 c(2, 50, 50, 20, 1),  # The layer structure of the deep neural network.
 # The first element is the number of input variables.
 # The last element is the number of output variables.
 hidden_layer_default = rectified_linear_unit_function,
 # for hidden layers, use rectified_linear_unit_function
 output_layer_default = linearUnitDerivative
 # for regression, use linearUnitDerivative function
)

# print the layer weights
# this function can print heatmap, histogram, or a surface
print_weight(dnn_regression, 1, type = "heatmap")

print_weight(dnn_regression, 2, type = "surface")

print_weight(dnn_regression, 3, type = "histogram")


}

