% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{defm-names}
\alias{defm-names}
\alias{get_Y_names}
\alias{get_X_names}
\title{Access to the names of a model's datasets}
\usage{
get_Y_names(m)

get_X_names(m)
}
\arguments{
\item{m}{An object of class \link{DEFM}.}
}
\value{
A character vector.

A character vector with the names of the dependent or independent
variables.
}
\description{
Retrieve the column names of the dependent variable (\code{y}) and independent
variable (\code{x}) of an object of class \link{DEFM}.
}
\examples{
#' Using Valente's SNS data
data(valentesnsList)

# Creating the DEFM object
mymodel <- new_defm(
  id = valentesnsList$id,
  X = valentesnsList$X,
  Y = valentesnsList$Y,
  order = 0
)

# Getting the names
get_X_names(mymodel)
get_Y_names(mymodel)
}
