% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defrost.R
\name{defrost}
\alias{defrost}
\title{Submit query to find updates in nomenclautre}
\usage{
defrost(query, asw = defrostR::asw_synonyms, interactive = F,
  return.no.matches = F)
}
\arguments{
\item{query}{vector of taxon names to be processed (can also be tip labels of a phylogeny for example)}

\item{asw}{amphibian species of the world synonym reference table on which to base new names on. Default setting will use the internally stored data set that may not be the most up-to-date.}

\item{interactive}{logical argument (default=FALSE) of whether to allow an "on the fly" decision to be made on what name to take if synonym matches multiple names. FLASE will return all possible names for a given query as a string, TRUE will ask the user to select one.}

\item{return.no.matches}{logical argument of whether to leave taxa not found in the reference table blank or whether to fill in the names provided by the query. default is FALSE}
}
\value{
this function returns a data frame with the following information/columns: original/input names, "stripped" names with no formatting, status of what action has been taken, updated names as recommended by the reference table
}
\description{
This function takes a query (a list of taxon names to be assessed) and the amphibian species of the world synonym table (preferrably generated with the function getSynonyms(), or loaded from the data set stored internally) as input and returns an updated list of names.
}
\details{
Two logical arguments can be turned on to a) allow an "on the fly" decision to be made on what name to take if synonym matches multiple names (if not, it will return all possible names) and to b) return the original query name if no match is found
}
\examples{
defrost(query=c("Bufo calamita", "Bufo viridis"))
}
