/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.mgf;

import ch.fgcz.proteomics.dto.MassSpecMeasure;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Scanner;

public class ReadStdIn {
    public static MassSpecMeasure read() {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        MassSpecMeasure massSpectrometryMeasurement = new MassSpecMeasure(null);
        BufferedReader bufferedreader = new BufferedReader(inputStreamReader);
        try {
            String line = "";
            int chargeState = 0;
            int id = 0;
            String searchEngine = null;
            String typ = null;
            double peptidMass = 0.0;
            double rt = 0.0;
            ArrayList<Double> mz = new ArrayList<Double>();
            ArrayList<Double> intensity = new ArrayList<Double>();
            while ((line = bufferedreader.readLine()) != null) {
                String[] partEqual = line.split("=");
                String[] partSpace = line.split(" ");
                if (line.equals("BEGIN IONS")) {
                    chargeState = 0;
                    id = massSpectrometryMeasurement.getMSlist().size();
                    searchEngine = null;
                    typ = null;
                    peptidMass = 0.0;
                    rt = 0.0;
                    mz = new ArrayList();
                    intensity = new ArrayList();
                    continue;
                }
                if (line.equals("END IONS")) {
                    massSpectrometryMeasurement.addMS(typ, searchEngine, mz, intensity, peptidMass, rt, chargeState, id);
                    continue;
                }
                if (line.contains("CHARGE")) {
                    chargeState = Integer.parseInt(partEqual[1].substring(0, 1));
                    continue;
                }
                if (line.contains("TITLE")) {
                    typ = partEqual[1];
                    continue;
                }
                if (line.contains("RTINSECONDS")) {
                    rt = Double.parseDouble(partEqual[1]);
                    continue;
                }
                if (line.contains("PEPMASS")) {
                    String[] pepmasssplit = partEqual[1].split(" ");
                    peptidMass = Double.parseDouble(pepmasssplit[0]);
                    continue;
                }
                if (partSpace.length <= 1 || !ReadStdIn.isDouble(partSpace[0]) || !ReadStdIn.isDouble(partSpace[1])) continue;
                mz.add(Double.parseDouble(partSpace[0]));
                intensity.add(Double.parseDouble(partSpace[1]));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return massSpectrometryMeasurement;
    }

    private static boolean isDouble(String string) {
        Scanner scanner = new Scanner(string);
        boolean b = scanner.hasNextDouble();
        scanner.close();
        return b;
    }
}

