% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delim_consensus.R
\name{delim_consensus}
\alias{delim_consensus}
\title{Estimate a Majority-Vote Consensus}
\usage{
delim_consensus(delim, n_match = NULL)
}
\arguments{
\item{delim}{Output from \link{delim_join}.}

\item{n_match}{An integer. Threshold for Majority-Vote calculations. If not specified,
returns a warning and the threshold will be defined as \code{ceiling(ncol(delim[, -1])/2)}.}
}
\value{
an object of class \link[tibble:tbl_df-class]{tbl_df}.
}
\description{
\code{delim_consensus()} estimates a majority-vote consensus over the output of
\link{delim_join} in a row-wise manner.
}
\details{
\code{delim_consensus()} iterates row-by-row, counting the number of matching species
partition names across all species delimitations methods in \link{delim_join} output.
If the sum of identical partition names is greater or equal \code{n_match},
the consensus column will be filled with its partition name. Otherwise,
consensus column will be filled with \link[base:NA]{NA}.
}
\examples{

# estimate a majority vote consensus
delim_consensus <- delim_consensus(geophagus_delims, n_match= 5)

# check
delim_consensus


}
\author{
Pedro S. Bittencourt
}
