% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/euler_stochastic.R
\name{euler_stochastic}
\alias{euler_stochastic}
\title{Euler-Maruyama method solution for a stochastic differential equation.}
\usage{
euler_stochastic(
  deterministic_rate,
  stochastic_rate,
  initial_condition,
  parameters = NULL,
  t_start = 0,
  deltaT = 1,
  n_steps = 1,
  D = 1
)
}
\arguments{
\item{deterministic_rate}{The 1 or multi dimensional system of equations for the deterministic part of the differential equation, written in formula notation as a vector (i.e.  c(dx ~ f(x,y), dy ~ g(x,y)))}

\item{stochastic_rate}{The 1 or multi dimensional system of equations for the stochastic part of the differential equation, written in formula notation as a vector (i.e.  c(dx ~ f(x,y), dy ~ g(x,y)))}

\item{initial_condition}{(REQUIRED) Listing of initial conditions, as a vector}

\item{parameters}{The values of the parameters we are using}

\item{t_start}{The starting time point (defaults to t = 0)}

\item{deltaT}{The timestep length (defaults to 1)}

\item{n_steps}{The number of timesteps to compute solution (defaults to n_steps = 1)}

\item{D}{diffusion coefficient for the stochastic part of the SDE}
}
\value{
A tidy of data frame the solutions
}
\description{
\code{euler_stochastic} solves a multi-dimensional differential equation with the Euler-Maruyama method with stochastic elements.
}
\examples{
### Simulate the stochastic differential equation dx = r*x*(1-x/K) dt + dW(t)
# Identify the deterministic and stochastic parts of the DE:
deterministic_logistic <- c(dx ~ r*x*(1-x/K))
stochastic_logistic <- c(dx ~ 1)

# Identify the initial condition and any parameters
init_logistic <- c(x=3)

logistic_parameters <- c(r=0.8, K=100) # parameters: a named vector

# Identify how long we run the simulation
deltaT_logistic <- .05 # timestep length
timesteps_logistic <- 200 # must be a number greater than 1

# Identify the standard deviation of the stochastic noise
D_logistic <- 1

# Do one simulation of this differential equation
logistic_out <- euler_stochastic(
deterministic_rate = deterministic_logistic,
stochastic_rate = stochastic_logistic,
initial_condition = init_logistic,
parameters = logistic_parameters,
deltaT = deltaT_logistic,
n_steps = timesteps_logistic, D = D_logistic
)
### Simulate a stochastic process for the tourism model presented in
### Sinay, Laura, and Leon Sinay. 2006. “A Simple Mathematical
### Model for the Effects of the Growth of Tourism on Environment.”
### In International Tourism Conference. Alanya, Turkey.
### where we have the following SDE:
### dr = r*(1-r)-a*v dt, dv = b*v*(r-v) dt + v*(r-v) dW(t)

# Identify the deterministic and stochastic parts of the DE:
deterministic_tourism<- c(dr ~ r*(1-r)-a*v, dv ~ b*v*(r-v))
stochastic_tourism <-  c(dr ~ 0, dv ~ v*(r-v))

# Identify the initial condition and any parameters
init_tourism <- c(r = 0.995, v = 0.00167)
tourism_parameters <- c(a = 0.15, b = 0.3316)   #

deltaT_tourism <- .5 # timestep length
timeSteps_tourism <- 200 # must be a number greater than 1

# Identify the diffusion coefficient
D_tourism <- .05

# Do one simulation of this differential equation
tourism_out <- euler_stochastic(
  deterministic_rate = deterministic_tourism,
 stochastic_rate = stochastic_tourism,
 initial_condition = init_tourism,
 parameters = tourism_parameters,
 deltaT = deltaT_tourism,
 n_steps = timeSteps_tourism,
 D = D_tourism
)
}
