% Generated by roxygen2 (4.0.1): do not edit by hand
\name{assign_values_to_branches_edgePar}
\alias{assign_values_to_branches_edgePar}
\title{Assign values to edgePar of dendrogram's branches}
\usage{
assign_values_to_branches_edgePar(object, value, edgePar, skip_leaves = FALSE,
  warn = dendextend_options("warn"), ...)
}
\arguments{
\item{object}{a dendrogram object}

\item{value}{a new value scalar for the edgePar attribute.}

\item{edgePar}{the value inside edgePar to adjust.}

\item{skip_leaves}{logical (FALSE) - should the leaves be skipped/ignored?}

\item{warn}{logical (default from dendextend_options("warn") is FALSE).
Set if warning are to be issued, it is safer to keep this at TRUE,
but for keeping the noise down, the default is FALSE.}

\item{...}{not used}
}
\value{
A dendrogram, after adjusting the edgePar attribute in all of its branches,
}
\description{
Go through the dendrogram branches and updates the values inside its edgePar

If the value has Inf then the value in edgePar will not be changed.
}
\examples{
\dontrun{

dend <- USArrests[1:5,] \%>\% dist \%>\% hclust \%>\% as.dendrogram
plot(dend)
dend <- assign_values_to_branches_edgePar(object=dend, value = 2, edgePar = "lwd")
plot(dend)
dend <- assign_values_to_branches_edgePar(object=dend, value = 2, edgePar = "col")
plot(dend)
dend <- assign_values_to_branches_edgePar(object=dend, value = 2, edgePar = "lty")
plot(dend)

}
}
\seealso{
\link{get_branches_attr}
}

