% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noded_with_condition.R
\name{noded_with_condition}
\alias{noded_with_condition}
\title{Find which nodes satisfies a condition}
\usage{
noded_with_condition(dend, condition, include_leaves = TRUE,
  include_branches = TRUE, na.rm = FALSE, ...)
}
\arguments{
\item{dend}{a dendrogram dend}

\item{condition}{a function that gets a node and return TRUE or FALSE
(based on whether or not that node/tree fulfills the "condition")}

\item{include_leaves}{logical. Should leaves attributes be included as well?}

\item{include_branches}{logical. Should non-leaf (branch node) 
attributes be included as well?}

\item{na.rm}{logical. Should NA attributes be REMOVED from the resulting vector?}

\item{...}{passed to the condition function}
}
\value{
A logical vector with TRUE/FALSE, specifying for each of the dendrogram's nodes if it fulfills the condition or not.
}
\description{
Goes through a tree's nodes in order to return a vector 
with whether (TRUE/FALSE) each node satisies some condition (function)
}
\examples{
\dontrun{

library(dendextend)

set.seed(23235)
ss <- sample(1:150, 10 )

# Getting the dend dend
dend <- iris[ss,-5] \%>\% dist \%>\% hclust \%>\% as.dendrogram
dend \%>\% plot



this is the basis for branches_attr_by_labels
has_any_labels <- function(sub_dend, the_labels) any(labels(sub_dend) \%in\% the_labels)
cols <- noded_with_condition(dend, has_any_labels,
            the_labels = c("126","109", "59")) \%>\% 
            ifelse(2,1)
set(dend, "branches_col", cols) \%>\% plot

# Similar to branches_attr_by_labels - but for heights!
high_enough <- function(sub_dend, height) attr(sub_dend, "height") > height
cols <- noded_with_condition(dend, high_enough, height = 1) \%>\% ifelse(2,1)
set(dend, "branches_col", cols) \%>\% plot

}

}
\seealso{
\link{branches_attr_by_labels}, \link{get_leaves_attr}, \link{nnodes}, \link{nleaves}
}

