% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\name{click_rotate}
\alias{click_rotate}
\alias{click_rotate.default}
\alias{click_rotate.dendrogram}
\title{Interactively rotate a tree object}
\usage{
click_rotate(x, ...)

\method{click_rotate}{default}(x, ...)

\method{click_rotate}{dendrogram}(x, plot = TRUE, plot_after = plot,
  horiz = FALSE, continue = FALSE, ...)
}
\arguments{
\item{x}{a tree object (either a \code{dendrogram} or \code{hclust})}

\item{...}{parameters passed to the plot}

\item{plot}{(logical) should the dendrogram first be plotted.}

\item{plot_after}{(logical) should the dendrogram be plotted after
the rotation?}

\item{horiz}{logical. Should the plot be normal or horizontal?}

\item{continue}{logical. If TRUE, allows the user to keep
clicking the plot until a click is made on the labels.}
}
\value{
A rotated tree object
}
\description{
Lets te user click a plot of dendrogram
and rotates the tree based on the location of the click.

Code for mouse selection of (sub-)cluster to be rotated
}
\examples{
# create the dend:
dend <- USArrests \%>\% dist \%>\% hclust("ave") \%>\%  
as.dendrogram \%>\% color_labels

\dontrun{
# play with the rotation once
dend <- click_rotate(dend)
dend <- click_rotate(dend, horiz = TRUE)
# keep playing with the rotation:
while(TRUE) dend <- click_rotate(dend)
# the same as
dend <- click_rotate(dend, continue = TRUE)
}

}
\seealso{
\code{\link{rotate.dendrogram}}
}
\author{
Andrej-Nikolai Spiess, Tal Galili
}
