% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual.R
\name{manual_trim_detect}
\alias{manual_trim_detect}
\title{Manually select a starting or ending location of a density profile}
\usage{
manual_trim_detect(failure, label = "")
}
\arguments{
\item{failure}{A dp object, usually see dpload.}

\item{label}{Optional label to be displayed on the plot after the
file}
}
\value{
The x position selected on the graph, row number in the dp$data data frame.
}
\description{
Follow-up to automatic trim functions or to be used manually, will
display a plot with the density profiles. Most commonly used in
automatic failure corrections by the function correct_failures. Use
your mouse to select starting/ending point on the plot, your
selection will then be displayed on the plot. Either returns a
numeric value or NA in case of errors. There are two special cases:
when encountering an error with a label = " - PICK START" it will
return the starting position, and with label " - PICK STOP" it will
return the ending position. These labels are used when correcting
several density profiles at once using \code{correct_failures}.
This function uses \code{graphics::locator}, which only works on
screen devices X11, windows and quartz. It will not work on other
devices, returning NA.
}
\examples{
## load a single file
dp  <- dpload(system.file("extdata", "00010001.dpa", package = "densitr"))
## get a starting point on the plot
\donttest{
manual_trim_detect(dp)
}
}
\seealso{
dptrim, dptriml
}
