% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paired_test_categorical.R
\name{paired_test_categorical}
\alias{paired_test_categorical}
\title{Paired test for categorical variables}
\usage{
paired_test_categorical(tab)
}
\arguments{
\item{tab}{a frequency table (an integer matrix)}
}
\value{
A list with components
        `P` (the computed P-value),
        `stat` (the test statistic, either t or F),
        `df` (degrees of freedom),
        `testname` (test name),
        `statname` (statistic name),
        `namefun` ("paired_tstat", "rep_aov"),
        `latexstat` (LaTeX representation of statname),
        `plotmathstat` (for R - the plotmath representation of
            `statname`, as a character string),
        `note` (contains a character string note about the test).
}
\description{
Statistical tests for paired categorical variable.
}
\details{
If the test is requested for two paired groups, the
\code{\link[stats]{mcnemar.test}} is used.

If the test is requested for more than two paired groups, the test
based on Cochran-Mantel-Haenzen for repeated measures is used
(powered by \code{\link[stats]{mantelhaen.test}})
}
\note{
This function could be used as `catTest` option in the
\code{\link[Hmisc]{summary.formula}} with method `reverse`.
}
\examples{
\donttest{
  library(Hmisc)

  data(Arthritis)

  ## two groups
  summary(Treatment ~ Sex,
    data = Arthritis,
    method = "reverse",
    test = TRUE,
    catTest = paired_test_categorical
  )

  ## more than two groups
  summary(Improved ~ Sex,
    data = Arthritis,
    method = "reverse",
    test = TRUE,
    catTest = paired_test_categorical
  )
}
}
