% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls.R
\name{cls2val}
\alias{cls2val}
\alias{cls2val.character}
\alias{cls2val.factor}
\alias{cls2val.cont_table}
\title{Convert class to values}
\usage{
cls2val(x, pos = 0, xfirst = NULL, xlast = NULL, wlast = NULL, ...)

\method{cls2val}{character}(x, pos = 0, xfirst = NULL, xlast = NULL, wlast = NULL, ...)

\method{cls2val}{factor}(x, pos = 0, xfirst = NULL, xlast = NULL, wlast = NULL, ...)

\method{cls2val}{cont_table}(x, pos = 0.5, ..., y = 1)
}
\arguments{
\item{x}{a series that contains a class of values, the first and
last characters should be any of \code{[}, \code{(}, \verb{]}, \verb{)} and the
other characters should be interpreted as two numerical values
separated by a \verb{,}}

\item{pos}{a numeric between 0 and 1, 0 for the lower bond, 1 for
the upper bond, 0.5 for the center of the class (and any other
value between 0 and 1)}

\item{xfirst}{center of the first class, if one wants to specifie
something different from the average of the lower and the upper
bonds}

\item{xlast}{the center of the last class, if one wants to specifie
something different from the average of the lower and the upper
bonds}

\item{wlast}{in the case where the upper bond is infinite and
\code{xlast} is not provided, the upper bond of the last class is
set to the lower bond of the last class and the range of the
previous class times this coefficient (which default value is
one)}

\item{...}{further arguments}

\item{y}{the index of the variable for which the \code{cls2val} method
for \code{cont_table} should be applied}
}
\value{
a numerical vector
}
\description{
Convert a string (or factor) which represents a class to a value of
the underlying variable
}
\examples{

# wage is a class of wage in the wages data set ; first
# extract unique values
wgs <- wages \%>\% pull(wage) \%>\% levels
# compute the lower bonds
wgs \%>\% cls2val(0)
# lower bonds with a user specified center value for the first class
wgs \%>\% cls2val(0, xfirst = 0.30) \%>\% head
# compute the upper bonds
wgs \%>\% cls2val(1)
# note that the Inf upper bond is replaced by 50 + (50 - 40), ie
# the lower bond plus the range of the previous class
wgs \%>\% cls2val(1, xlast = 100) \%>\% tail
# xlast is provided (the center of the last class) and the upper
# bond is adapted accordingly, which means 50 + (100 - 50) * 2 =
# 150
wgs \%>\% cls2val(1, wlast = 3) \%>\% tail
# wlast is provided, so that the range of the last class is three
# times the range of the previous one
}
\author{
Yves Croissant
}
