% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrend.R
\name{detrending}
\alias{detrending}
\alias{img_detrend_boxcar}
\alias{img_detrend_exp}
\alias{img_detrend_polynom}
\title{Detrend images.}
\usage{
img_detrend_boxcar(img, l, seed = NULL, parallel = FALSE)

img_detrend_exp(img, tau, cutoff = 0.05, seed = NULL, parallel = FALSE)

img_detrend_polynom(img, degree, seed = NULL, parallel = FALSE)
}
\arguments{
\item{img}{The image series to be detrended. This must be a 3-dimensional
array of non-negative integers, with the matrix defined as \code{img[, , 1]}
being the first frame of the image series.}

\item{l}{The length parameter for \emph{boxcar} detrending. The size of the
sliding window will be \code{2 * l + 1}. This must be a positive integer. Set
this to "auto" to use Nolan's algorithm to automatically find a suitable
value for this parameter (recommended).}

\item{seed}{Random numbers may be generated during the detrending process.
For reproducibility, you can set a seed for this random number generation
here.}

\item{parallel}{Would you like to use multiple cores to speed up this
function? If so, set the number of cores here, or to use all available
cores, use \code{parallel = TRUE}.}

\item{tau}{The \eqn{tau} parameter for \emph{exponential filtering} detrending.
This must be a positive number. Set this to "auto" to use Nolan's algorithm
to automatically find a suitable value for this parameter (recommended).}

\item{cutoff}{In \emph{exponential filtering} detrending, for the weighted
average, every point gets a weight. This can slow down the computation
massively. However, many of the weights will be approximately zero. With
cutoff, we say that any point with weight less than or equal to \code{cutoff}
times the maximum weight may be ignored; so with \code{cutoff = 0.05}, any
weight less than 5\% of the maximum weight may be ignored. The default
value of this parameter is sensible and its value should not be set to
anything else without good reason.}

\item{degree}{The degree of the polynomial to use for the polynomial
detrending. This must be a positive integer. Set this to "auto" to use
Nolan's algorithm to automatically find a suitable value for this
parameter (recommended).}
}
\value{
The detrended image, an object of class \link{detrended_img}.
}
\description{
Correct images for bleaching (or any other effect that introduces an unwanted
trend) by \emph{detrending}.
}
\details{
There are 3 detrending methods available: \emph{boxcar}, \emph{exponential filtering}
and \emph{polynomial}. These are described in detail in Nolan et al., 2017.
\itemize{\item \emph{Boxcar} detrending with parameter \eqn{l} is a moving average
detrending method using a sliding window of size \eqn{2l + 1}. \item
\emph{Exponential filtering} detrending is a moving weighted average method where
for parameter \eqn{tau} the weights are calculated as exp\eqn{(- t / tau)}
where \eqn{t} is the distance from the point of interest. \item \emph{Polynomial}
detrending works by fitting a polynomial line to a series of points and then
correcting the series to remove the trend detailed by this polynomial fit.}
}
\examples{
\dontrun{
## These examples are not run on CRAN because they take too long.
## You should still try them for yourself.
img <- read_tif(system.file('extdata', 'bleached.tif', package = 'detrendr'),
                n_ch = 1)
corrected <- img_detrend_boxcar(img, "auto", seed = 0, parallel = 2)
corrected10 <- img_detrend_boxcar(img, 10, seed = 0, parallel = 2)
corrected50 <- img_detrend_boxcar(img, 50, seed = 0, parallel = 2)
corrected100 <- img_detrend_boxcar(img, 100, seed = 0, parallel = 2)
corrected300 <- img_detrend_boxcar(img, 300, seed = 0, parallel = 2)
corrected <- img_detrend_exp(img, "auto", seed = 0, parallel = 2)
corrected10 <- img_detrend_exp(img, 10, seed = 0, parallel = 2)
corrected50 <- img_detrend_exp(img, 50, seed = 0, parallel = 2)
corrected100 <- img_detrend_exp(img, 100, seed = 0, parallel = 2)
corrected1000 <- img_detrend_exp(img, 1000, seed = 0, parallel = 2)
corrected <- img_detrend_polynom(img, "auto", seed = 0, parallel = 2)
corrected1 <- img_detrend_polynom(img, 1, seed = 0, parallel = 2)
corrected2 <- img_detrend_polynom(img, 2, seed = 0, parallel = 2)
corrected4 <- img_detrend_polynom(img, 4, seed = 0, parallel = 2)
corrected8 <- img_detrend_polynom(img, 8, seed = 0, parallel = 2)
}
}
\references{
Rory Nolan, Luis A. J. Alvarez, Jonathan Elegheert, Maro
Iliopoulou, G. Maria Jakobsdottir, Marina Rodriguez-Muñoz, A. Radu
Aricescu, Sergi Padilla-Parra; nandb—number and brightness in R with a
novel automatic detrending algorithm, Bioinformatics,
https://doi.org/10.1093/bioinformatics/btx434.
}
