\name{CombPlateau_sim}
\alias{CombPlateau_sim}
\alias{print.CombPlateau_sim}
\title{Combination design Simulator for the combination of two agents where toxicity is increasing with the dose of both agent and efficacy is increasing and possibly plateaus with the dose of one agent}
\description{
\code{CombPlateau_sim} is used to generate simulation replicates of phase I/II clinical trial for combination studies where the toxicity is assumed to increase with the dose of both agents, and the efficacy is asummed to increase with one agent and increase and possibily plateaus with the second agent. This phase I/II adaptive design is performed using the design proposed by Riviere et al. entitled "A Bayesian dose finding design for clinical trials combining a cytotoxic agent with a molecularly targeted agent".
}
\usage{
CombPlateau_sim(ndose_a1, ndose_a2, p_tox, p_eff, tox_max, eff_min, 
prior_tox_a1, prior_tox_a2, prior_eff_a1, prior_eff_a2, n, cohort_start=3, 
cohort=3, time_full, poisson_rate, cycle=0, nsim, c_tox=0.85, c_eff=0.10, 
seed = 2174892, threads=0)
}
\arguments{
  \item{ndose_a1}{Number of dose levels for agent 1.}
  \item{ndose_a2}{Number of dose levels for agent 2.}
  \item{p_tox}{A matrix of the true toxicity probabilities associated with the combinations. True toxicity probabilities should be entered with agent 1 in row and agent 2 in column, with increasing toxicity probabilities with both row and column numbers (see examples).}
  \item{p_eff}{A matrix of the true efficacy probabilities associated with the combinations. True efficacy probabilities should be entered with agent 1 in row and agent 2 in column, with increasing (or plateau) efficacy probabilities with both row and column numbers (see examples).}
  \item{tox_max}{Maximum acceptable toxicity probability.}
  \item{eff_min}{Minimum efficacy probability desired.}
  \item{prior_tox_a1}{A vector of initial guesses of toxicity probabilities associated with the doses of agent 1. Must be of length \code{ndose_a1}.}
  \item{prior_tox_a2}{A vector of initial guesses of toxicity probabilities associated with the doses of agent 2. Must be of length \code{ndose_a2}.}
  \item{prior_eff_a1}{A vector of initial guesses of efficacy probabilities associated with the doses of agent 1. Must be of length \code{ndose_a1}.}
  \item{prior_eff_a2}{A vector of initial guesses of efficacy probabilities associated with the doses of agent 2. Must be of length \code{ndose_a2}.}
  \item{n}{Total number of patients to include in the trial.}
  \item{cohort_start}{Cohort size for the start-up phase. Default is set at 3 (recommended).}
  \item{cohort}{Cohort size for the model-based phase. Default is set at 3.}
  \item{time_full}{Full follow-up time window for efficacy evaluation.}
  \item{poisson_rate}{A value indicating the rate for the Poisson process used to simulate patient arrival, i.e. expected number of arrivals per observation window.}
  \item{cycle}{Minimum waiting time between two dose cohorts (usually a toxicity cycle). Default value is set at 0.}
  \item{nsim}{Number of simulations.}
  \item{c_tox}{Tocixity threshold for decision rules. The default value is set at 0.85.}
  \item{c_eff}{Efficacy threshold for decision rules. The default value is set at 0.10.}
  \item{seed}{Seed of the random number generator. Default value is set at 2174892.}
  \item{threads}{Number of threads to use to do the computations. If 0, it uses as many threads as available processors.} 
}
\value{
An object of class "CombPlateau_sim" is returned, consisting of the operating characteristics of the design specified. Objects generated by \code{CombPlateau_sim} contain at least the following components: 
\item{p_tox}{True toxicities.}
\item{p_eff}{True efficacies.}
\item{rec_dose}{Percentage of Selection.}
\item{n_pat_dose}{Number of patients at each combination.}
\item{n_tox_dose}{Number of toxicities at each combination.}
\item{n_eff_dose}{Number of toxicities at each combination.}
\item{inconc}{Percentage of inclusive trials.}
\item{nsim}{Number of simulations.}
\item{cohort_start}{Cohort size for the start-up phase.}
\item{cohort}{Cohort size for the model-based phase.}
\item{n}{Total number of patients planned in the trial.}
\item{pat_tot}{Total patients accrued.}
\item{tox_max}{Toxicity upper bound.}
\item{eff_min}{Efficacy lower bound.}
\item{prior_tox_a1}{Prior toxicity probabilities for agent 1.}
\item{prior_tox_a2}{Prior toxicity probabilities for agent 2.}
\item{prior_eff_a1}{Prior efficacy probabilities for agent 1.}
\item{prior_eff_a2}{Prior efficacy probabilities for agent 2.}
\item{c_tox}{Tocixity threshold.}
\item{c_eff}{Efficacy threshold.}
\item{time_full}{Full follow-up time for efficacy is also reminded.}
\item{poisson_rate}{Rate for Poisson process is also reminded.}
\item{duration}{Trial mean duration.}
}
\references{
Riviere, M-K., Yuan, Y., Dubois, F., and Zohar, S. (2015). A Bayesian dose finding design for clinical trials combining a cytotoxic agent with a molecularly targeted agent. Journal of the Royal Statistical Society - Series C.
}
\author{Jacques-Henri Jourdan and Marie-Karelle Riviere-Jourdan \email{eldamjh@gmail.com}}
\seealso{
  \code{\link{CombPlateau_next}}.
}
\examples{
p_tox_sc1 = t(matrix(c(0.10,0.15,0.30,0.45,
                     0.15,0.30,0.45,0.50,
                     0.30,0.45,0.55,0.65),nrow=4,ncol=3))
p_eff_sc1 = t(matrix(c(0.25,0.25,0.26,0.27,
                     0.40,0.41,0.41,0.42,
                     0.55,0.55,0.56,0.56),nrow=4,ncol=3))
p_tox_sc4 = t(matrix(c(0.01,0.04,0.08,0.10,
                     0.03,0.05,0.10,0.15,
                     0.07,0.10,0.15,0.30),nrow=4,ncol=3))
p_eff_sc4 = t(matrix(c(0.05,0.20,0.30,0.32,
                     0.10,0.30,0.45,0.46,
                     0.20,0.40,0.60,0.61),nrow=4,ncol=3))                     
prior_tox_a1 = c(0.2, 0.3, 0.4)
prior_eff_a1 = c(0.3, 0.4, 0.5)
prior_tox_a2 = c(0.12, 0.2, 0.3, 0.4)
prior_eff_a2 = c(0.3, 0.4, 0.5, 0.59)

# UNCOMMENT THOSE EXAMPLES
#sim1 = CombPlateau_sim(ndose_a1=3, ndose_a2=4, p_tox=p_tox_sc1, 
#p_eff=p_eff_sc1, tox_max=0.30, eff_min=0.20, prior_tox_a1=prior_tox_a1, 
#prior_tox_a2=prior_tox_a2, prior_eff_a1=prior_eff_a1, 
#prior_eff_a2=prior_eff_a2, n=75, cohort_start=3, cohort=3, time_full=7, 
#poisson_rate=0.28, cycle=0, nsim=2000, c_tox=0.85, c_eff=0.10, seed = 2174892, 
#threads=0)
                        
#sim1
                        
#sim2 = CombPlateau_sim(ndose_a1=3, ndose_a2=4, p_tox=p_tox_sc4, 
#p_eff=p_eff_sc4, tox_max=0.30, eff_min=0.20, prior_tox_a1=prior_tox_a1, 
#prior_tox_a2=prior_tox_a2, prior_eff_a1=prior_eff_a1, 
#prior_eff_a2=prior_eff_a2, n=75, cohort=3, time_full=7, poisson_rate=0.28, 
#nsim=1000)

#sim2

# Dummy example, running quickly
useless = CombPlateau_sim(ndose_a1=2, ndose_a2=2, 
p_tox=matrix(c(0.05,0.10,0.15,0.25),nrow=2), 
p_eff=matrix(c(0.10,0.35,0.30,0.65),nrow=2), tox_max=0.35, eff_min=0.20, 
prior_tox_a1=c(0.1,0.3), prior_tox_a2=c(0.1,0.3), prior_eff_a1=c(0.2,0.4),
prior_eff_a2=c(0.2,0.4),
n=15, cohort=3, time_full=7, poisson_rate=1, nsim=1) 
}
