% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_project.R
\name{create_project}
\alias{create_project}
\title{Creates a pre-populated project for DfE R}
\usage{
create_project(
  path,
  init_renv = TRUE,
  include_structure_for_pkg = FALSE,
  create_publication_proj = FALSE,
  include_github_gitignore,
  ...
)
}
\arguments{
\item{path}{Path of the new project}

\item{init_renv}{Boolean; initiate renv in the project.
Default is set to true.}

\item{include_structure_for_pkg}{Boolean; Additional folder structure for
package development. Default is set to false.}

\item{create_publication_proj}{Boolean; Should the folder structure be for a
publication project. Default is set to false.}

\item{include_github_gitignore}{Boolean; Should a strict .gitignore file for
GitHub be created.}

\item{...}{Additional parameters, currently not used}
}
\value{
No return values, the project and its contents are created
}
\description{
Creates a pre-populated project for DfE R
}
\details{
This function creates a new project with a custom folder structure.
It sets up the \verb{R/} folder and template function scripts,
initializes \code{{testthat}} and adds tests for the function scripts,
builds the core project structure, creates a .gitignore file,
creates a readme, and optionally initializes \code{{renv}}.
}
\examples{
\dontrun{

# Call the function to create a new project
dfeR::create_project(
  path = "C:/path/to/your/new/project",
  init_renv = TRUE,
  include_structure_for_pkg = FALSE,
  create_publication_proj = FALSE,
  include_github_gitignore = TRUE
)
}
}
