% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.dfm}
\alias{plot.dfm}
\alias{screeplot.dfm}
\title{Plot DFM}
\usage{
\method{plot}{dfm}(
  x,
  method = switch(x$em.method, none = "2s", "qml"),
  type = c("joint", "individual", "residual"),
  scale.factors = TRUE,
  ...
)

\method{screeplot}{dfm}(x, ...)
}
\arguments{
\item{x}{an object class 'dfm'.}

\item{method}{character. The factor estimates to use: one of \code{"qml"}, \code{"2s"}, \code{"pca"} or \code{"all"} to plot all estimates.}

\item{type}{character. The type of plot: \code{"joint"}, \code{"individual"} or \code{"residual"}.}

\item{scale.factors}{logical. Standardize factor estimates, this usually improves the plot since the factor estimates corresponding to the greatest PCA eigenvalues tend to have a greater variance than the data.}

\item{\dots}{for \code{plot.dfm}: further arguments to \code{\link{plot}}, \code{\link{ts.plot}}, or \code{\link{boxplot}}, depending on the \code{type} of plot. For \code{screeplot.dfm}: further arguments to \code{\link{screeplot.ICr}}.}
}
\value{
Nothing.
}
\description{
Plot DFM
}
\examples{
\donttest{
# Fit DFM with 3 factors and 3 lags in the transition equation
mod = DFM(diff(BM14_M), r = 3, p = 3)
plot(mod)
plot(mod, type = "individual", method = "all")
plot(mod, type = "residual")
}

}
