#' Dynamic Factor Models
#'
#' @description
#'
#' *dfms* provides efficient estimation of Dynamic Factor Models via the EM Algorithm --- following Doz, Giannone & Reichlin (2011, 2012) and Banbura & Modugno (2014). Contents:
#'
#' **Information Criteria to Determine the Number of Factors**
#'
#'  \code{\link[=ICr]{ICr()}}\cr
#'
#'  - \code{\link[=plot.ICr]{plot(<ICr>)}}\cr
#'  - \code{\link[=screeplot.ICr]{screeplot(<ICr>)}}\cr
#'
#' **Fit a Dynamic Factor Model**
#'
#'  \code{\link[=DFM]{DFM()}}\cr
#'
#'  - \code{\link[=summary.dfm]{summary(<dfm>)}}\cr
#'  - \code{\link[=plot.dfm]{plot(<dfm>)}}\cr
#'  - \code{\link[=as.data.frame.dfm]{as.data.frame(<dfm>)}}\cr
#'  - \code{\link[=residuals.dfm]{residuals(<dfm>)}}\cr
#'  - \code{\link[=fitted.dfm]{fitted(<dfm>)}}
#'
#' **Generate Forecasts**
#'
#'  \code{\link[=predict.dfm]{predict(<dfm>)}}\cr
#'
#'  - \code{\link[=plot.dfm_forecast]{plot(<dfm_forecast>)}}\cr
#'  - \code{\link[=as.data.frame.dfm_forecast]{as.data.frame(<dfm_forecast>)}}\cr
#'
#' **Fast Stationary Kalman Filtering and Smoothing**
#'
#'  \code{\link[=SKF]{SKF()}} --- Stationary Kalman Filter\cr
#'  \code{\link[=FIS]{FIS()}} --- Fixed Interval Smoother\cr
#'  \code{\link[=SKFS]{SKFS()}} --- Stationary Kalman Filter + Smoother\cr
#'
#'  **Helper Functions**
#'
#'  \code{\link[=.VAR]{.VAR()}} --- (Fast) Barebones Vector-Autoregression\cr
#'  \code{\link[=ainv]{ainv()}} --- Armadillo's Inverse Function\cr
#'  \code{\link[=apinv]{apinv()}} --- Armadillo's Pseudo-Inverse Function\cr
#'  \code{\link[=tsnarmimp]{tsnarmimp()}} --- Remove and Impute Missing Values in a Multivariate Time Series\cr
#'  \code{\link[=em_converged]{em_converged()}} --- Convergence Test for EM-Algorithm\cr
#'
#' **Data**
#'
#'  \code{\link{BM14_M}} --- Monthly Series by Banbura and Modugno (2014)\cr
#'  \code{\link{BM14_Q}} --- Quarterly Series by Banbura and Modugno (2014)\cr
#'  \code{\link{BM14_Models}} --- Series Metadata + Small/Medium/Large Model Specifications\cr
#'
#' @references
#' Doz, C., Giannone, D., & Reichlin, L. (2011). A two-step estimator for large approximate dynamic factor models based on Kalman filtering. *Journal of Econometrics, 164*(1), 188-205. <doi:10.1016/j.jeconom.2011.02.012>
#'
#' Doz, C., Giannone, D., & Reichlin, L. (2012). A quasi-maximum likelihood approach for large, approximate dynamic factor models. *Review of Economics and Statistics, 94*(4), 1014-1024. <doi:10.1162/REST_a_00225>
#'
#' Banbura, M., & Modugno, M. (2014). Maximum likelihood estimation of factor models on datasets with arbitrary pattern of missing data. *Journal of Applied Econometrics, 29*(1), 133-160. <doi:10.1002/jae.2306>
#'
#' @docType package
#' @name dfms-package
#' @aliases dfms
#'
NULL
