% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMAfunctions.R
\name{CompLogML}
\alias{CompLogML}
\title{Computes Marginal Likelihoods for Each Clique and Value of Nmissing}
\usage{
CompLogML(D, Nmissing, delta)
}
\arguments{
\item{D}{A marginal array of the list overlap counts.}

\item{Nmissing}{The vector of possible values for the missing cell.}

\item{delta}{The prior hyper parameter for the Dirichlet distribution.}
}
\value{
The log marginal likelihood of the marginal table.
}
\description{
Assembles all of the pieces of the marginal likelihoods to be used to
calculate the posterior probability of each model/value of Nmissing.
}
\examples{

Y <- c(0, 27, 37, 19, 4, 4, 1, 1, 97, 22, 37, 25, 2, 1, 3, 5,
       83, 36, 34, 18, 3, 5, 0, 2, 30, 5, 23, 8, 0, 3, 0, 2)
Y <- array(Y, dim = c(2, 2, 2, 2, 2))

# Compute marginal array over lists 1 and 3
D <- apply(Y, c(1, 3), sum)

dga:::CompLogML(D, 1:300, 0.5)
}
\references{
Madigan, David, and Jeremy C. York. "Bayesian methods for
estimation of the size of a closed population."  Biometrika 84.1 (1997):
19-31.
}
\author{
James Johndrow \email{james.johndrow@gmail.com} and Kristian Lum
\email{kl@hrdag.org}
}
\keyword{BMA}
\keyword{capture-recapture}
\keyword{estimation}
\keyword{multiple}
\keyword{systems}
