% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_urn_frequencies.R
\name{get_urn_frequencies}
\alias{get_urn_frequencies}
\title{Get word count frequencies for a list of URNs or dhlabids}
\usage{
get_urn_frequencies(urns = NULL, dhlabids = NULL)
}
\arguments{
\item{urns}{A list or data frame of URNs from the National Library of Norway.
If a data frame, it should have a column named 'urn'.}

\item{dhlabids}{A list of 'dhlabid' ids from National Library DHLAB.}
}
\value{
A data frame with two columns: 'dhlabid' and 'frequencies'.
Each row represents a library text resource with its corresponding word count.
}
\description{
This function takes a list of National Library of Norway (NB) identifiers,
either URNs or dhlabids, and returns the word count for each object.
It queries the National Library's API to fetch the word count data.
}
\examples{
# Example usage with a list of URNs
urn_list <- c("URN:NBN:no-nb_digibok_2008051404065", "URN:NBN:no-nb_digibok_2010092120011")
word_counts <- get_urn_frequencies(urn_list)
print(word_counts)

# Example usage with a data frame of URNs
urn_list <-  c("URN:NBN:no-nb_digibok_2008051404065", "URN:NBN:no-nb_digibok_2010092120011")
urn_dataframe <- data.frame(urn = urn_list)
word_counts <- get_urn_frequencies(urn_dataframe)

}
