% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary_functions.R
\name{lambda_ros}
\alias{lambda_ros}
\title{Function to calculate robust lambda estimator}
\usage{
lambda_ros(model)
}
\arguments{
\item{model}{A linear model L1 fitted with the \code{rq} function from the \code{quantreg} package.}
}
\value{
Robust lambda estimator, which is based on the residuals order statistics.
}
\description{
Function to compute a robust lambda estimator, which is based on the residuals order statistics.
}
\examples{
require(quantreg)
data(stackloss)
model_L1 = regL1(stack.loss ~ stack.x)
lambda_ros(model_L1)

}
