% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-phone_old.R
\name{ph_possible}
\alias{ph_possible}
\title{Check if a phone number is possible for a given region}
\usage{
ph_possible(phone, country, detailed = FALSE)
}
\arguments{
\item{phone}{Character vector of phone numbers to check}

\item{country}{Character vector of region codes. If length = 1, the same
region code is used for all phone numbers}

\item{detailed}{If detailed = FALSE, ph_possible returns a logical vector
that indicates whether the number is possible or not.
If detailed = TRUE, ph_possible returns more detailed
information about FALSE numbers.}
}
\value{
if detailed = FALSE, logical vector flagging possible phone numbers.
If detailed = TRUE, character vector with detailed information about
failures.
}
\description{
\strong{ph_possible is soft-deprecated and will be removed in a future release.}
}
\details{
Check whether a phone number is a possible number. It provides a more lenient
check than isValidNumber(PhoneNumber) in the following sense:
\enumerate{
\item It only checks the length of phone numbers. In particular, it doesn't
check starting digits of the number.
\item It doesn't attempt to figure out the type of the number, but uses
general rules which applies to all types of phone numbers in a
region. Therefore, it is much faster than isValidNumber.
\item For fixed line numbers, many regions have the concept of area code,
which together with subscriber number constitute the national
significant number. It is sometimes okay to dial the subscriber
number only when dialing in the same area. This function will return
true if the subscriber-number-only version is passed in. On the other
hand, because isValidNumber validates using information on both
starting digits (for fixed line numbers, that would most likely be
area codes) and length (obviously includes the length of area codes
for fixed line numbers), it will return false for the
subscriber-number-only version.
}
}
\examples{
x <- c(0, 0123, "0404 753 123", "61410123817", "+12015550123")
ph_possible(x, "AU")
}
