% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_region.R
\name{pick_region}
\alias{pick_region}
\title{Choose region of interest}
\usage{
pick_region(
  coords = NULL,
  hemisphere = c("left", "right", "midline"),
  region = c("frontal", "central", "parietal", "occipital", "temporal", "face"),
  ROI = NULL,
  tol = 1e-06
)
}
\arguments{
\item{coords}{A data frame, matrix or named tibble with numeric columns of "x" and "y" sensor coordinates. If not defined, HCGSN256 template is used. See details for more information about coordinate requirements.}

\item{hemisphere}{A character vector denoting hemisphere to choose. Possible values: \code{"left"}, \code{"right"}, \code{"midline"} or any combination of them. If not defined, both hemispheres with midline are chosen.}

\item{region}{A character vector denoting region to choose. Possible values: \code{"frontal"}, \code{"central"}, \code{"parietal"}, \code{"occipital"}, \code{"temporal"}, \code{"face"} or any combination of them. If not defined, all regions are chosen.}

\item{ROI}{A character or factor vector with labels of regions, aligned row-wise with \code{coords}. If not defined, the predefined vector (according to HCGSN256 template determined by an expert from Central European Institute of Technology, Masaryk University, Brno, Czech Republic) is used.}

\item{tol}{A numeric value indicating tolerance for midline selection. (Values of x fulfilling abs(x) < tol are denoted as midline.) Default value is 1e-6.}
}
\value{
A tibble or data frame subset of \code{coords} filtered by the selected \code{region} and \code{hemisphere} criteria.
}
\description{
The function extracts the selected regions or hemisphere (or a combination of both) from the specified sensor coordinates.
}
\details{
If the \code{coords} input is data frame or matrix with no named columns, the first column is considered as "x" coordinate and second as "y" coordinate.
For the correct selection of the hemisphere with own coordinates, it is necessary that the 2D layout is oriented with the nose up and that the midline electrodes should have a zero x-coordinate (or approximately zero within tolerance). Otherwise, the results will not match reality.

Notes:
The option \code{hemisphere = "left"} (respectively \code{hemisphere = "right"}) means only the left hemisphere without the midline. If you want to include midline as well, use \code{hemisphere = c("left", "midline")} (respectively \code{hemisphere = c("right", "midline")}).

The matching of region/hemisphere is exact and the function will stop with an the function stops with an error if no coordinates match the requested \code{region} and \code{hemisphere} combination.
}
\examples{

# Choosing regions from HCGSN256 template
# a) temporal region in left hemisphere
pick_region(hemisphere = "left", region = "temporal")
# b) frontal and central region
region_fc <- pick_region(region = c("frontal", "central"))
head(region_fc)
# c) left hemisphere including midline
hemi_lm <- pick_region(hemisphere = c("left", "midline"))
head(hemi_lm)
# plot the result in c)
plot(hemi_lm$x, hemi_lm$y, pch = 16, asp = 1)
}
\seealso{
\code{\link{point_mesh}}
}
