#' Key of correct answers for \code{GMATtest} dataset.
#'
#' @description The \code{GMATkey} is a vector of factors representing correct answers of
#' generated \code{GMATtest} data set based on Graduate Management Admission Test (GMAT, Kingston et al., 1985).
#'
#' @usage data(GMATkey)
#'
#' @author
#' Adela Hladka (nee Drabinova) \cr
#' Institute of Computer Science of the Czech Academy of Sciences \cr
#' Faculty of Mathematics and Physics, Charles University \cr
#' \email{hladka@@cs.cas.cz} \cr
#'
#' Patricia Martinkova \cr
#' Institute of Computer Science of the Czech Academy of Sciences \cr
#' \email{martinkova@@cs.cas.cz} \cr
#'
#' @references
#' Kingston, N., Leary, L., & Wightman, L. (1985). An exploratory study of the applicability of item response theory
#' methods to the Graduate Management Admission Test. ETS Research Report Series, 1985(2): 1--64.
#'
#' Martinkova, P., Drabinova, A., Liaw, Y. L., Sanders, E. A., McFarland, J. L., & Price, R. M. (2017).
#' Checking equity: Why differential item functioning analysis should be a routine part of developing conceptual
#' assessments. CBE--Life Sciences Education, 16(2), rm2, \doi{10.1187/cbe.16-10-0307}.
#'
#' @keywords datasets
#'
#' @seealso \code{\link{GMAT}}, \code{\link{GMATtest}}
#'
#' @format A nominal vector with 20 values representing correct answers to items of \code{GMATtest}
#' dataset. For more details see \code{\link{GMATtest}}.
"GMATkey"
