% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_tools.R
\name{push_text_char_data}
\alias{push_text_char_data}
\title{push char_data of one rtext objet to another}
\usage{
push_text_char_data(from_text = NULL, to_text = NULL, from_token = NULL,
  to_token = NULL, from_i = NULL, to_i = NULL, x = NULL, warn = TRUE)
}
\arguments{
\item{from_text}{text to pull data from}

\item{to_text}{text to push data to}

\item{from_token}{token of text to pull data from
(e.g.: data.frame(from=1, to=4))}

\item{to_token}{token of text to push data to
(e.g.: data.frame(from=1, to=4))}

\item{from_i}{index of characters to pull data from}

\item{to_i}{index of characters to push data to}

\item{x}{name of the char_data variable to pull and push -
defaults to NULL which will result in cycling through all availible
variables}

\item{warn}{should function warn about non-uniform pull values (those will
not be pushed to the other text)}
}
\description{
Function that takes a rtext object pulls specific char_data from it and
pushes this information to another rtext object.
}
\details{
Note, that this is an intelligent function.

It will e.g. always decrease the hierarchy level (hl) found when pulling and
decrease it before pushing it forward therewith allowing that already present
coding might take priority over those pushed.

Furthermore, the function will only push values if the pulled values are all
the same. Since, character index lengths that are used for pulling and
pushing might differ in length there is no straight forward rule to translate
non uniform value sequences in value sequnces of differing length. Note, that
of cause the values might differ between char_data variables but not within.
In case of non-uniformity the function will simply do nothing.
}

