% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffusion.R
\name{predict.diffusion}
\alias{predict.diffusion}
\title{Predict future periods of a fitted diffusion curve.}
\usage{
\method{predict}{diffusion}(object, h = 10, ...)
}
\arguments{
\item{object}{\code{diffusion} object, produced using \code{\link{diffusion}}.}

\item{h}{Forecast horizon.}

\item{...}{Unused argument.}
}
\value{
Returns an object of class \code{diffusion}, which contains:
\itemize{
\item \code{type} diffusion curve type used
\item \code{call} calls function fitted
\item \code{w} named vector of fitted parameters
\item \code{x} actuals
\item \code{fit} fitted values of model
\item \code{frc} forecasts for future periods.
\item \code{mse} insample Mean Squared Error
\item \code{prew} the \code{w} of the previous generation
\item \code{pval} p-values for \code{w}
}
}
\description{
Calculates the values for h future periods of a fitted diffusion curve.
}
\note{
This function populates the matrix frc of the \code{diffusion} object used as input.
}
\examples{
 fit <- diffusion(tsChicken[, 2])
 fti <- predict(fit,20)
 plot(fit)

}
\seealso{
\code{\link{diffusion}}.
}
\author{
Oliver Schaer, \email{info@oliverschaer.ch},

Nikoloas Kourentzes, \email{nikoloas@kourentzes.com}
}
