% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pasynorm.R
\name{asynorm}
\alias{asynorm}
\alias{pasynorm}
\alias{rasynorm}
\alias{dasynorm}
\alias{qasynorm}
\title{The asymmetric normal distribution.}
\usage{
dasynorm(x, mu = 0, sigma = 1, tau = 0.5)
pasynorm(q, mu = 0, sigma = 1, tau = 0.5)
qasynorm(p, mu = 0, sigma = 1, tau = 0.5)
rasynorm(n, mu = 0, sigma = 1, tau = 0.5)
}
\arguments{
\item{q}{vector of quantiles.}

\item{mu}{location parameter and mode of the distribution.}

\item{sigma}{comparable to the standard deviation. Must be positive.}

\item{tau}{asymmetry parameter.}

\item{x}{vector of locations.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \eqn{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dasynorm} gives the density, \code{pasynorm} gives the distribution function, \code{qasynorm} gives the quantile function, and \code{rasynorm} generates random deviates.

Corresponds to the normal distribution for \eqn{\tau = 0.5}.

The length of the result is determined by \code{n} for \code{rasynorm}, and is the maximum of the lengths of the numerical arguments for the other functions.

The numerical arguments other than \code{n} are recycled to the length of the result.
}
\description{
Density, distribution function, quantile function and random generation for the asymmetric normal distribution with the parameters \code{mu}, \code{sigma} and \code{tau}.
}
\details{
The asymmetric normal distribution has the following density\cr
\eqn{f(x) =   (2\sqrt{\tau(1-\tau)/\pi}/\sigma)/(\sqrt{1-\tau} + \sqrt{\tau)}\exp(-|(\tau - (x <= \mu))|*(x - \mu)^2/\sigma^2)}
The cdf is derived by integration of the distribution function by using the \code{\link[stats]{integrate}} function.
}
\examples{

hist(rasynorm(1000))

qg <- qasynorm(0.1, 1, 2, 0.5)

pasynorm(qg, 1, 2, 0.5)

ax <- c(1:1000)/100-5
plot(ax,dasynorm(ax), type = 'l')
}
\concept{asynorm}
