% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{smoothed.part}
\alias{smoothed.part}
\title{Extracting the smoothed part of a twoStepsBenchmark}
\usage{
smoothed.part(object)
}
\arguments{
\item{object}{a twoStepsBenchmark object.}
}
\value{
a time-serie
}
\description{
The function \code{smoothed.part} returns the smoothed part of a
\link{twoStepsBenchmark}. It derives from the residuals of the
aggregated regression, with some differences :
\itemize{
\item it is eventually integrated if \code{include.differenciation=TRUE}.
\item it is extrapolated to match the domain window.
\item it is smoothed with an additive Denton benchmark.
}
}
\examples{
benchmark <- twoStepsBenchmark(turnover,construction); smoothed.part(benchmark)

}
