% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareGraphs.R
\name{prepareGraphs}
\alias{prepareGraphs}
\title{Prepare Graphs}
\usage{
prepareGraphs(
  raw_data_input,
  project_title = "",
  directedNet = TRUE,
  selfInteract = FALSE,
  weightedGraph = TRUE
)
}
\arguments{
\item{raw_data_input}{The raw edge and weight list processed from the tabulate_edges() function.}

\item{project_title}{The title of the project.}

\item{directedNet}{Sets the graph to be directed. Edges will have a direction. Default is set to Directed. If undirected, edges have no direction}

\item{selfInteract}{Removes self interactions in the graph (such as person 1 to person 1 interactions). Default removes self-interactions.}

\item{weightedGraph}{Graph will add weights to the edges to a set of nodes based on the weight specified on the list. Default allows for weights on the graph.}
}
\value{
Stores the igraph graph object, graph adjacency matrix, edge and weight lists, project title, and user options for directed, self interactions, and weighted to list object.
}
\description{
Prepares the graphical object from the prepared edge and weight list data frame
}
\examples{
df <- sampleData1
prepNet <- tabulate_edges(df, iscsvfile = FALSE)
baseNet <- prepareGraphs(prepNet, project_title = "Sample Data 1",
directedNet = TRUE, selfInteract = FALSE, weightedGraph = TRUE)

}
