% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeData.R
\name{writeData}
\alias{writeData}
\title{Exports graphs and data objects from the package to disk}
\usage{
writeData(project_name, objectfile, dirpath = NULL)
}
\arguments{
\item{project_name}{Name of the project}

\item{objectfile}{The saved data object data file}

\item{dirpath}{The working directory that the files will be saved to. Path required for write function to work. Current directory, use "." as the dirpath}
}
\value{
Saves the requested object file to disk. Saves graphs or summary information sheets.
}
\description{
Saves information from graphs and data objects created by package. Plots are saved as .tiff at 300 dpi
}
\examples{

attributeData <- attributeData
df <- sampleData1

prepNet <- tabulate_edges(df, iscsvfile = FALSE)
baseNet <- prepareGraphs(prepNet, project_title = "Sample Data 1",
directedNet = TRUE, selfInteract = FALSE, weightedGraph = TRUE)
NetPlots2 <- plotGraphs2(baseNet, attribute1 = attributeData$ethnicity,
attribute2 = attributeData$gender, attribute.node.labels = attributeData$node,
attribute1.label = "Ethnicity", attribute2.label = "Gender")

writeData("Sample Data 1", NetPlots2, dirpath = tempdir())

}
