% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_acp_utils.R
\name{hcpcavar}
\alias{hcpcavar}
\title{PCA plot of variables}
\usage{
hcpcavar(
  modelo,
  axes = c(1, 2),
  nombrearchivo = NULL,
  colorVar = "forestgreen",
  cos2 = 0,
  colorCos = "darkorchid",
  titulos = c("Bien Representados", "Mal Representados")
)
}
\arguments{
\item{modelo}{an object of class PCA [FactoMineR].}

\item{axes}{a numeric vector of length 2 specifying the dimensions to be plotted.}

\item{nombrearchivo}{a character value specifying the name to use when the plot is downloaded.}

\item{colorVar}{a color for the variables well represented.}

\item{cos2}{a numeric value from 0 to 1 specifying the quality of the variables.}

\item{colorCos}{a color for the variables badly represented.}

\item{titulos}{a character vector of length 2 specifying the titles to use on legend.}
}
\value{
Highchart plot
}
\description{
PCA plot of variables
}
\examples{
p <- discoveR:::PCA(iris[, -5], graph = FALSE)
hcpcavar(p)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
