% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_afc_utils.R
\name{e_afcbi}
\alias{e_afcbi}
\title{AFC biplot}
\usage{
e_afcbi(
  modelo,
  axes = c(1, 2),
  colorRow = "steelblue",
  colorCol = "forestgreen",
  cos2Row = 0,
  cos2Col = 0,
  colorRowCos = "firebrick",
  colorColCos = "darkorchid",
  titulos = c("Bien Representados", "Mal Representados"),
  etq = T
)
}
\arguments{
\item{modelo}{an object of class CA [FactoMineR].}

\item{axes}{a numeric vector of length 2 specifying the dimensions to be plotted.}

\item{colorRow}{a color for the individuals well represented.}

\item{colorCol}{a color for the variables well represented.}

\item{cos2Row}{a numeric value from 0 to 1 specifying the quality of the individuals.}

\item{cos2Col}{a numeric value from 0 to 1 specifying the quality of the variables.}

\item{colorRowCos}{a color for the individuals badly represented.}

\item{colorColCos}{a color for the variables badly represented.}

\item{titulos}{a character vector of length 2 specifying the titles to use on legend.}

\item{etq}{a boolean, whether to add label to graph or not.}
}
\value{
echarts4r plot
}
\description{
AFC biplot
}
\examples{
p <- FactoMineR::CA(iris[, -5], graph = FALSE)
e_afcbi(p)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
