% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disequilibrium_model.R
\name{marginal_effects}
\alias{marginal_effects}
\alias{shortage_marginal}
\alias{shortage_probability_marginal}
\alias{shortage_marginal,disequilibrium_model-method}
\alias{shortage_probability_marginal,disequilibrium_model-method}
\title{Marginal effects}
\usage{
shortage_marginal(object, parameters, variable)

shortage_probability_marginal(object, parameters, variable, aggregate = "mean")

\S4method{shortage_marginal}{disequilibrium_model}(object, parameters, variable)

\S4method{shortage_probability_marginal}{disequilibrium_model}(object, parameters, variable, aggregate = "mean")
}
\arguments{
\item{object}{A disequilibrium model object.}

\item{parameters}{A vector of parameters.}

\item{variable}{Variable name for which the effect is calculated.}

\item{aggregate}{Mode of aggregation. Valid options are "mean" (the default) and
"at_the_mean".}
}
\value{
The estimated effect of the passed variable.
}
\description{
Returns the estimated effect of a variable.
}
\section{Functions}{
\itemize{
\item \code{shortage_marginal}: Marginal effect on market system

Returns the estimated marginal effect of a variable on the market system. For a
system variable \eqn{x} with demand coefficient \eqn{\beta_{d, x}} and supply
coefficient \eqn{\beta_{s, x}}, the marginal effect on the market system  is given by
\deqn{M_{x} = \frac{\beta_{d, x} - \beta_{s, x}}{\sqrt{\sigma_{d, x}^{2} +
\sigma_{s, x}^{2} - 2 \rho_{ds} \sigma_{d, x} \sigma_{s, x}}}.}

\item \code{shortage_probability_marginal}: Marginal effect on shortage probabilities

Returns the estimated marginal effect of a variable on the probability of observing
a shortage state. The mean marginal effect on the shortage probability is given by
\deqn{M_{x} \mathrm{E}\phi(D - S)}
and the marginal effect at the mean by
\deqn{M_{x} \phi(\mathrm{E}(D - S)),}
where \eqn{M_{x}} is the marginal effect on the system, \eqn{D} is the demanded
quantity, \eqn{S} the supplied quantity, and \eqn{\phi} is the standard normal
density.
}}

\examples{
\donttest{
# initialize the model using the houses dataset
model <- new(
  "diseq_deterministic_adjustment", # model type
  c("ID", "TREND"), "TREND", "HS", "RM", # keys, time, quantity, and price variables
  "RM + TREND + W + CSHS + L1RM + L2RM + MONTH", # demand specification
  "RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH", # supply specification
  fair_houses(), # data
  correlated_shocks = FALSE # allow shocks to be correlated
)

# estimate the model object (BFGS is used by default)
est <- estimate(model, control = list(maxit = 1e+5))

# get the mean marginal effect of variable "RM" on the shortage probabilities
shortage_probability_marginal(model, est@coef, "RM")

# get the marginal effect at the mean of variable "RM" on the shortage probabilities
shortage_probability_marginal(model, est@coef, "CSHS", aggregate = "at_the_mean")

# get the marginal effect of variable "RM" on the system
shortage_marginal(model, est@coef, "RM")
}
}
