% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotRaw.R
\name{plotRaw}
\alias{plotRaw}
\title{Used to plot the results of the imageJ analysis}
\usage{
plotRaw(projectName, ymin = 0, ymax = 250, xmin = 0, xmax = 40,
  xplots = 6, height = 4, width = 8, cexPt = 0.6, cexX = 0.8,
  cexY = 0.8, standardLoc = 2.5, nameVector = TRUE,
  plotStandardLoc = TRUE, showNum = FALSE, popUp = TRUE,
  overwrite = TRUE, savePDF = TRUE)
}
\arguments{
\item{projectName}{the short name to be used for the project}

\item{ymin}{a numeric value indicating the minimum y value plotted in each plot}

\item{ymax}{a numeric value indicating the maximum y value plotted in each plot}

\item{xmin}{a numeric value indicating the minimum x value plotted in each plot}

\item{xmax}{a numeric value indicating the maximum x value plotted in each plot}

\item{xplots}{a numeric value indicating how many plots to plot in each row}

\item{height}{a numeric value indicating the height of the pdf file generated}

\item{width}{a numeric value indicating the width of the pdf file generated}

\item{cexPt}{a numeric value indicating the size to plot for points}

\item{cexX}{a numeric value indicating the size of x-axis text}

\item{cexY}{a numeric value indicating the size of y-axis text}

\item{standardLoc}{a numberic value indicating the location (on the disk) to use to standardize intensity across photographs. The position of standardLoc is a position that should theoretically have the same intensity in all photographs, i.e., the white of the disk. The defaul value (2.5mm) was chosen after testing of 6mm disks that contain some writing. If smaller disks are used standardLoc should be scaled appropriately.}

\item{nameVector}{either a logial value indicating whether to plot the photograph names above the plot; a vector the same length as the number of photographs containing the desired names. Defaults to TRUE.}

\item{plotStandardLoc}{a logical value indicating whether to draw a dashed vertical line at the standardization point that is used in \code{maxLik} and \code{createDataframe}}

\item{showNum}{a logical value indicating whether to annotate each plot with the photograph number (determined alphabetically from the photograph names). This can be helpful for later functions that require the numerical place of a photograph with a clear halo.}

\item{popUp}{a logical value indicating whether to pop up the figure after it has been created}

\item{overwrite}{a logical value indicating whether to overwrite existing figures created on the same day for the same project name}

\item{savePDF}{a logical value indicating whether to save a PDF file or open a new quartz window. Defaults to TRUE (saves a pdf file).}
}
\value{
A pdf file with one plot for each photograph is saved to visualize the results of imageJ analyses
}
\description{
\code{plotRaw} creates a pdf figure showing the results of the ImageJ analysis, with one plot for each photograph. This function is optional, and is primarily for visualization purposes.
}
\examples{
\dontrun{
plotRaw("myProject")
plotRaw("myProject", ymin = 50, ymax = 300, xplots=2, height=3, width=4, plotStandardLoc=FALSE)
}
}

