% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.utilities.R
\name{extract.dispRity}
\alias{extract.dispRity}
\title{Extracting disparity values.}
\usage{
extract.dispRity(
  data,
  subsets,
  observed = TRUE,
  rarefaction = FALSE,
  concatenate = TRUE
)
}
\arguments{
\item{data}{A \code{dispRity} object containing disparity results.}

\item{subsets}{Optional, a \code{numeric} or \code{character} for which subsets to get (if missing, the value for all subsets are given).}

\item{observed}{A \code{logical} value indicating whether to output the observed (\code{TRUE} (default)) or the bootstrapped values (\code{FALSE}).}

\item{rarefaction}{Optional, a single \code{numeric} value corresponding to the rarefaction level (as the number of elements; if missing, the non-rarefied values are output).}

\item{concatenate}{When the disparity metric is a distribution, whether to concatenate it (\code{TRUE}; default) or to return each individual metric.}
}
\description{
Extracts the disparity from a \code{dispRity} object.
}
\examples{
## Load the disparity data based on Beck & Lee 2014
data(disparity)

## Extracting the observed disparity
extract.dispRity(disparity)

## Extracting the bootstrapped disparity
boot_disp <- extract.dispRity(disparity, observed = FALSE)
str(boot_disp)
## Or only the rarefied (5) data
boot_disp_rare <- extract.dispRity(disparity, observed = FALSE,
     rarefaction = 5)

}
\seealso{
\code{\link{dispRity}}, \code{\link{get.subsets}}.
}
\author{
Thomas Guillerme
}
