% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randtest.dispRity.R
\name{randtest.dispRity}
\alias{randtest.dispRity}
\title{Random (permutation) test}
\usage{
\method{randtest}{dispRity}(
  data,
  subsets,
  metric,
  replicates = 100,
  resample = TRUE,
  alter = "two-sided",
  ...
)
}
\arguments{
\item{data}{The \code{matrix} to draw from.}

\item{subsets}{A \code{vector} of elements to test (or a \code{list} of \code{vectors}).}

\item{metric}{A \code{function} to be the statistic to apply to the subset.}

\item{replicates}{A \code{numeric} value for the number of replicates (\code{default = 100}).}

\item{resample}{\code{logical} whether to resample the full distribution (\code{TRUE}) or the distribution without the subset (\code{FALSE}).}

\item{alter}{The alternative hypothesis. Can be \code{"two-sided"} (default), \code{"greater"} or \code{"lesser"}.}

\item{...}{optional arguments to be passed to \code{metric}.}
}
\value{
This function returns a \code{"randtest"} object that can be passed to the generic S3 functions \code{\link[ade4]{print.randtest}} or \code{\link[ade4]{plot.randtest}}.
The output also contains to extra elements \code{output$observed} and \code{output$random} containing the raw results of respectively the observed and random tests.
}
\description{
Performs a random test (aka permutation test) on a \code{matrix} or a \code{dispRity} object.
}
\details{
This test checks whether the metric calculated on a given subset of the data is significantly different from the metric calculated on any random subset of the same size.
In other words: does the given subset have a clearly different disparity value than the rest of the data?

First, the \code{metric} (statistic) is applied to the \code{subset} sampled from the \code{data} (population).
Second, the \code{metric} is applied to random equally sized subsets from the \code{data}.
If the observed difference falls out of the random differences distribution, the differences are significant.
This algorithm is based on a similar procedure than in \code{link[ade4]{rantest}}.

If \code{data} is a \code{dispRity} object, the \code{subsets}, \code{metric} and \code{replicates} can be left missing and are automatically inherited from the \code{dispRity} if it contains respectively subsets (from \code{\link{chrono.subsets}} or \code{\link{custom.subsets}}) a \code{metric} (from \code{\link{dispRity}}) and bootstrap draws (from \code{boot.matrix}).
}
\examples{
## Simple example
dummy_matrix <- matrix(rnorm(500), 100, 5)

## Testing whether the mean of a random subset
## is different than the means of 100 subsets
dummy_test <- randtest.dispRity(dummy_matrix,
                                subset = sample(1:100, 20),
                                metric = mean)
dummy_test ; plot(dummy_test)

## Applying this on dispRity objects
data(disparity)
test_disparity <- test.dispRity(disparity,
                                test = randtest.dispRity)

## The summarised results
summary(test_disparity)

## Plotting the results
plot(test_disparity)

}
\seealso{
\code{link[ade4]{randtest}}
}
\author{
Thomas Guillerme
}
