% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtt.dispRity.R
\name{dtt.dispRity}
\alias{dtt.dispRity}
\title{dtt dispRity (from \code{geiger::dtt})}
\usage{
dtt.dispRity(
  data,
  metric,
  tree,
  nsim = 0,
  model = "BM",
  alternative = "two-sided",
  scale.time = TRUE,
  ...
)
}
\arguments{
\item{data}{A \code{dispRity} object or a \code{matrix}}

\item{metric}{The disparity metric to be passed to \code{\link{dispRity}}.}

\item{tree}{A \code{phylo} object matching the data and with a \code{root.time} element. Can be missing if \code{data} has a \code{tree} component.}

\item{nsim}{The number of simulations to calculate null disparity-through-time.}

\item{model}{A evolutionary model for the simulations (see \code{geiger::sim.char} - default is \code{"BM"}).}

\item{alternative}{The H1 alternative (for calculating the p-value). Can be \code{"two-sided"} (default), \code{"greater"} or \code{"lesser"}; see details.}

\item{scale.time}{Optional, whether to scale the time (between 0 and 1; \code{TRUE}, default) or not (\code{FALSE}).}

\item{...}{Any other arguments to be passed to \\code{geiger::dtt}.}
}
\description{
A wrapper for the \code{geiger::dtt} function working with any disparity metric.
}
\details{
See \code{geiger::dtt} for details.
}
\examples{

## Loading morphological data and a tree
data(BeckLee_mat50)
data(BeckLee_tree)

## The average squared pairwise distance metric (used in geiger::dtt)
average.sq <- function(X) mean(pairwise.dist(X)^2)

## Calculate the disparity of the dataset using dtt.dispRity
dispRity_dtt <- dtt.dispRity(data = BeckLee_mat50, metric = average.sq,
                             tree = BeckLee_tree, nsim = 20)

## Plotting the results
plot(dispRity_dtt)


}
\seealso{
\code{\link{test.dispRity}}, \code{\link{custom.subsets}}, \code{\link{chrono.subsets}}, \code{\link{plot.dispRity}}.
}
\author{
Thomas Guillerme
}
