% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.metric.R
\name{make.metric}
\alias{make.metric}
\title{Creating disparity metrics}
\usage{
make.metric(
  fun,
  ...,
  silent = FALSE,
  check.between.groups = FALSE,
  data.dim,
  tree = NULL,
  covar = FALSE
)
}
\arguments{
\item{fun}{A \code{function}.}

\item{...}{Some arguments to be passed to \code{fun}.}

\item{silent}{\code{logical}; if \code{FALSE} (default), the function will be verbose and give no output; if \code{TRUE}, the function will only output the function's dimension-level.}

\item{check.between.groups}{\code{logical}; if \code{TRUE}, the function will output a named list containing the metric level and a logical indicating whether the metric can be used between groups or not. If \code{FALSE} (default) the function only outputs the metric level.}

\item{data.dim}{optional, two \code{numeric} values for the dimensions of the matrix to run the test function testing. If missing, a default 5 rows by 4 columns matrix is used.}

\item{tree}{optional, a \code{phylo} object.}

\item{covar}{\code{logical}, whether to treat the metric as applied the a \code{data$covar} component (\code{TRUE}) or not (\code{FALSE}; default).}
}
\description{
Testing the dimension-level of disparity metrics
}
\details{
This function tests:
\itemize{
  \item 1: if your function can deal with a matrix as an \code{input}.
  \item 2: which dimension-level is your function (1, 2 or 3, see \code{\link{dispRity.metric}}).
  \item 3: whether the function can properly be implemented in the \code{dispRity} function.
}
The three different metric levels correspond to the dimensions of the output and are:
\itemize{
  \item "dimension-level 1": for functions that decompose a \code{matrix} into a single value.
  \item "dimension-level 2": for functions that decompose a \code{matrix} into a \code{vector}.
  \item "dimension-level 3": for functions that transform the \code{matrix} into another \code{matrix}.
}

For example, the disparity metric \code{\link[base]{sum}} of \code{\link[dispRity]{variances}} is composed of two metric dimension-levels:
\itemize{
  \item The \code{\link[dispRity]{variances}} (dimension-level 2) that calculates the variances for each column in a matrix (aggregates a \code{matrix} into a \code{vector}).
  \item The \code{\link[base]{sum}} (dimension-level 1) that transforms the \code{vector} of variances into a single value.
}
See function example for a concrete illustration (three different dimension-levels of the function \code{\link[base]{sum}}).

\emph{HINT:} it is better practice to name the first argument of \code{fun} \code{matrix} to avoid potential argument conflicts down the line (the \code{\link{dispRity}} function assumes the \code{matrix} argument for the parsing the metrics).

The input \code{fun} can be a "normal" metric function (i.e. that takes a matrix as first argument) or a "between.groups" metric (i.e. that takes two matrix as arguments). If the arguments are named \code{matrix} and \code{matrix2}, the metric will be assumed to be "between.groups" and be run in a \code{for} loop rather than a \code{apply} loop in \code{\link{dispRity}}.
}
\examples{
## A dimension-level 1 function
my_fun <- function(matrix) sum(matrix)
make.metric(my_fun)

## A dimension-level 2 function
my_fun <- function(matrix) apply(matrix, 2, sum)
make.metric(my_fun)

## A dimension-level 3 function
my_fun <- function(matrix) (matrix + sum(matrix))
make.metric(my_fun)

}
\seealso{
\code{\link{dispRity}}, \code{\link{dispRity.metric}}.
}
\author{
Thomas Guillerme
}
