% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.tip.edge.R
\name{match.tip.edge}
\alias{match.tip.edge}
\title{Match tips edge vector}
\usage{
match.tip.edge(vector, phylo, replace.na)
}
\arguments{
\item{vector}{a vector of variables (equal to the number of tips).}

\item{phylo}{a phylo object.}

\item{replace.na}{optional, what to replace NAs with.}
}
\value{
A vector of variables equal to the number of edges in the tree
}
\description{
Match a vector of tips with the an edge list
}
\examples{
## A random tree
tree <- rtree(20)

## A random vector of two variables for each tips
tip_values <- sample(c("blue", "red"), 20, replace = TRUE)

## Matching the colors (blue and red) to the tips descendants
edge_colors <- match.tip.edge(tip_values, tree, replace.na = "grey")

## Plotting the results
plot(tree, show.tip.label = FALSE, edge.color = edge_colors)
tiplabels(1:20, bg = tip_values)


}
\author{
Thomas Guillerme
}
