/** auto-generated by make_all.pl **/
#ifndef LAC_DIFFERENCE_OPTIONS_H
#define LAC_DIFFERENCE_OPTIONS_H 1

#include <map>
#include "base.h"

#include "implementations/BrayCurtis.h"
#include "implementations/Canberra.h"
#include "implementations/Chebyshev.h"
#include "implementations/Covariance.h"
#include "implementations/Euclidean.h"
#include "implementations/Equality.h"
#include "implementations/Hellinger.h"
#include "implementations/Jaccard.h"
#include "implementations/Mahalanobis.h"
#include "implementations/Manhattan.h"
#include "implementations/Minkowski.h"
#include "implementations/Pearson.h"
#include "implementations/Procrustes.h"

namespace LAC {

  namespace Difference {

    template< typename K, typename T >
    const std::map< K, Base<T>* >& make_options_map() {

      typedef typename std::map< K, Base<T>* > options_map_t;

      static options_map_t diff_options_map;

      diff_options_map["braycurtis"] = new BrayCurtis<T>;
      diff_options_map["canberra"] = new Canberra<T>;
      diff_options_map["chebyshev"] = new Chebyshev<T>;
      diff_options_map["covariance"] = new Covariance<T>;
      diff_options_map["euclidean"] = new Euclidean<T>;
      diff_options_map["equality"] = new Equality<T>;
      diff_options_map["hellinger"] = new Hellinger<T>;
      diff_options_map["jaccard"] = new Jaccard<T>;
      diff_options_map["mahalanobis"] = new Mahalanobis<T>;
      diff_options_map["manhattan"] = new Manhattan<T>;
      diff_options_map["minkowski"] = new Minkowski<T>;
      diff_options_map["pearson"] = new Pearson<T>;
      diff_options_map["procrustes"] = new Procrustes<T>;

      return diff_options_map;
    }
  }
}

#endif
